/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.fw.connmgr.HMCSSLContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.util.StringUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;

public class HMCServerSocketFactory
extends ServerSocketFactory {
    static String[] SSL_SERVER_SOCKET_ANON_SUITES = null;
    private static HMCServerSocketFactory FACTORY = new HMCServerSocketFactory();

    static HMCServerSocketFactory getFactory() {
        return FACTORY;
    }

    static boolean useLocalSockets(int port) {
        return CommonSystem.getCommonSystem().isUsingHTML() && port == 9940;
    }

    static ServerSocketFactory getServerSocketFactory(int port) {
        ServerSocketFactory factory = null;
        if (HMCServerSocketFactory.useLocalSockets(port)) {
            factory = ServerSocketFactory.getDefault();
        } else {
            try {
                factory = HMCSSLContext.getSSLContext().getServerSocketFactory();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return factory;
    }

    static void enableOnlyAnonSuites(SSLServerSocket socket) {
        if (SSL_SERVER_SOCKET_ANON_SUITES == null) {
            SSL_SERVER_SOCKET_ANON_SUITES = StringUtils.getMatches("anon", socket.getSupportedCipherSuites());
        }
        socket.setEnabledCipherSuites(SSL_SERVER_SOCKET_ANON_SUITES);
    }

    HMCServerSocketFactory() {
    }

    public ServerSocket createServerSocket() {
        throw new UnsupportedOperationException();
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.createServerSocket(port, 0, null);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.createServerSocket(port, backlog, null);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException, UnknownHostException {
        ServerSocket socket = null;
        socket = backlog == 0 ? HMCServerSocketFactory.getServerSocketFactory(port).createServerSocket(port) : (ifAddress == null ? HMCServerSocketFactory.getServerSocketFactory(port).createServerSocket(port, backlog) : HMCServerSocketFactory.getServerSocketFactory(port).createServerSocket(port, backlog, ifAddress));
        if (!HMCServerSocketFactory.useLocalSockets(port)) {
            HMCServerSocketFactory.enableOnlyAnonSuites((SSLServerSocket)socket);
        }
        return socket;
    }
}

